<?php include_once("includes/datos.php"); ?>
<?php include_once("includes/clases/select.php"); ?>
<?php
$evento;
$id = 0;
if (isset($_GET['id']) && is_numeric($_GET['id']) && $_GET['id'] > 0) {
    $id = $_GET['id'];
    $evento = $mysqli->query("SELECT * FROM eventos WHERE id = {$id}");
    if ($evento->num_rows != 1) {
        header("Location: index.php");
        exit();
    } else {
        $evento = $evento->fetch_assoc();
    }
} else {
    header("Location: index.php");
    exit();
}

?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zona Privada</title>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.0/themes/base/jquery-ui.css">

    <link rel="stylesheet" href="asset/style.css">




    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/ui/1.14.0/jquery-ui.js"></script>
    <!-- Place the first <script> tag in your HTML's <head> -->
    <script src="https://cdn.tiny.cloud/1/cqd5we7v96awl0waoo8iqiw30wrntutc7dvo2lhzh0zcmqfy/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>
    <script src="asset/js.js"></script>

</head>

<body>

    <header>
        <div><i onclick="menu();" class="fa-solid fa-bars"></i></div>
        <div class="centrar">
            <h1><?php echo $evento['evento']; ?></h1>
        </div>
        <div>
            <i onclick="history.back();" class="fa-solid fa-arrow-left"></i>
        </div>
    </header>
    <menu>
        <nav>
            <ul>
                <li><i onclick="menu();" class="fa-solid fa-xmark"></i></li>
                <li><a href="index.php"><i class="fa-solid fa-building-flag"></i> Instalaciones</a></li>
                <li><a href="eventos.php"><i class="fa-solid fa-masks-theater"></i> Eventos</a></li>
            </ul>
        </nav>
    </menu>
    <main>

        <?php
        if (isset($_GET['error'])) {
            $clase = "class='ok'";
            $texto = '<i class="fa-solid fa-circle-check"></i> Se ha Editado correctamente';
            $error = base64_decode($_GET['error']);
            if ($error != "false") {
                $clase = "class='error'";
                $texto = '<i class="fa-solid fa-bug"></i> ' . $error;
            }
            echo "<div {$clase}>{$texto}</div>";
        }
        ?>

        <div id="tabs">
            <ul>
                <li><a href="#tabs-1"><i class="fa-solid fa-pencil"></i> Editar</a></li>
                <li><a href="#tabs-2"><i class="fa-solid fa-image"></i> Fotos</a></li>
            </ul>
            <div id="tabs-1">
                <form class="formularios" action="includes/editar_evento.php" method="post">
                    <input type="hidden" name="id" value="<?php echo $evento['id'] ?>">
                    <input type="text" value="<?php echo $evento['evento'] ?>" name="evento" require placeholder="Evento" maxlength="500">
                    <textarea name="descripcion" id="descripcion" placeholder="Descripcion" maxlength="25000"><?php echo $evento['descripcion'] ?></textarea>
                    <input type="datetime-local" value="<?php echo $evento['fecha'] ?>" name="fecha" require placeholder="Fecha y hora">
                    <input type="number" value="<?php echo $evento['duracion'] ?>" name="duracion" require placeholder="Duración en minutos">
                    <?php
                    $instalaciones = $mysqli->query("SELECT * from instalaciones");
                    $instalaciones = $instalaciones->fetch_all(MYSQLI_NUM);

                    foreach ($instalaciones as $key => $value) {
                        if ($value[0] == $evento['instalacion']) {
                            $instalaciones[$key][2] = 1;
                        }
                    }
                    $tipos = new select($instalaciones, "instalacion", "instalacion", "Instalaciones");
                    ?>
                    <!-- <input type="file" name="fotos[]" multiple accept=".jpeg, .jpg"> -->
                    <div class="derecha m_arriba">
                        <button class="botones" type="submit"><i class="fa-solid fa-floppy-disk"></i> Guardar</button>
                    </div>
                </form>
            </div>
            <div id="tabs-2">
                <form class="formularios" action="includes/nuevas_fotos_evento.php" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="id" value="<?php echo $evento['id'] ?>">
                    <input type="file" name="fotos[]" multiple accept=".jpeg, .jpg">
                    <div class="derecha m_arriba">
                        <button class="botones" type="submit"><i class="fa-solid fa-floppy-disk"></i> Subir Fotos</button>
                    </div>
                </form>

                <hr>

                <ul class="listGrilla">
                    <?php
                    $fotos = $mysqli->query("SELECT * FROM fotos WHERE evento = {$id} order by id");
                    while ($foto = $fotos->fetch_assoc()) {
                        $imagen = "../imagenes/eventos/{$foto['id']}.jpeg";
                        echo "<li>
                                <div><img src='{$imagen}'></div>
                                <div><i onclick='confirmarBorrar({$foto['id']}, \"\", 1);' class='fa-solid fa-trash'></i></div>
                              </li>";
                    }
                    ?>
                </ul>
            </div>
        </div>
    </main>
    <footer onclick="confirmarBorrar(<?php echo $evento['id']; ?>, '', 3);">
       <i class="fa-solid fa-trash"></i> Borrar
    </footer>


    <script>
        $(function() {
            tinymce.init({
                selector: '#descripcion',
                plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount code',
                toolbar: 'undo redo | blocks fontfamily fontsize | code | bold italic underline strikethrough forecolor| link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
                language: 'es'
            });


            <?php
            $tab = 0;
            if (isset($_GET['tab']) && is_numeric($_GET['tab'])) {
                $tab = $_GET['tab'];
            }
            ?>
            $("#tabs").tabs({
                active: <?php echo $tab; ?>
            });
        })
    </script>
</body>

</html>