<?php include_once("includes/datos.php") ?>
<?php include_once("includes/clases/select.php") ?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zona Privada</title>

    <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.0/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="asset/style.css">

    <style>
        @media (width < 1200px) {
            header {
                display: grid;
                grid-template-columns: 15% 25% 60%;
            }
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/ui/1.14.0/jquery-ui.js"></script>

    <!-- Place the first <script> tag in your HTML's <head> -->
    <script src="https://cdn.tiny.cloud/1/cqd5we7v96awl0waoo8iqiw30wrntutc7dvo2lhzh0zcmqfy/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>

    <script src="asset/js.js"></script>



</head>

<body>

    <header>
        <div><i onclick="menu();" class="fa-solid fa-bars"></i></div>
        <div class="centrar">
            <h1>Eventos</h1>
        </div>
        <div>
            <form action="eventos.php" method="post" class="buscar">
                <input type="search" name="buscar" minlength="3" placeholder="Buscar..." required>
                <button type="submit" class="boton"><i class="fa-solid fa-magnifying-glass"></i></button>
            </form>
        </div>
    </header>
    <menu>
        <nav>
            <ul>
                <li><i onclick="menu();" class="fa-solid fa-xmark"></i></li>
                <li><a href="index.php"><i class="fa-solid fa-building-flag"></i> Instalaciones</a></li>
                <li><a href="eventos.php"><i class="fa-solid fa-masks-theater"></i> Eventos</a></li>
            </ul>
        </nav>
    </menu>
    <main>

        <?php
        if (isset($_GET['error'])) {
            $clase = "class='ok'";
            $texto = '<i class="fa-solid fa-circle-check"></i> Operación Correcta';
            $error = base64_decode($_GET['error']);
            if ($error != "false") {
                $clase = "class='error'";
                $texto = '<i class="fa-solid fa-bug"></i> ' . $error;
            }
            echo "<div {$clase}>{$texto}</div>";
        }
        ?>

        <div id="formulario_nuevo_evento">
            <form class="formularios" action="includes/nuevo_evento_desde_eventos.php" method="post" enctype="multipart/form-data">
                <div class="derecha m_arriba">
                    <i onclick="cerrarFormulario();" class="fa-solid fa-square-xmark"></i>
                </div>
                <?php
                $instalaciones = $mysqli->query("SELECT * from instalaciones");
                $instalaciones = $instalaciones->fetch_all(MYSQLI_NUM);
                $tipos = new select($instalaciones, "instalacion", "instalacion", "Instalaciones");
                ?>
                <input type="text" name="evento" required placeholder="Evento" maxlength="500">
                <textarea name="descripcion" id="descripcionevento" placeholder="Descripcion" maxlength="25000"></textarea>
                <input type="datetime-local" required name="fecha" placeholder="Fecha y Hora">
                <input type="number" name="duracion" placeholder="Duración en Minutos" required>
                <input type="file" name="fotos[]" accept=".jpeg, .jpg" multiple>
                <div class="derecha m_arriba">
                    <button type="submit" class="botones"><i class="fa-solid fa-floppy-disk"></i> Guardar</button>
                </div>
            </form>
        </div>


        <div id="listaEventos" class="lista">
            <?php
            $idinstalacion = 0;
            $contador = 0;
            if (isset($_POST['buscar']) && strlen($_POST['buscar']) > 3) {
                $buscar = $mysqli->real_escape_string($_POST['buscar']);
                echo "<h3>{$buscar}</h3>";
            ?>
                <div>
                    <ul class="list">
                        <?php
                        $eventos = $mysqli->query("SELECT id, evento, fecha, duracion FROM eventos where evento like '%{$buscar}%' or descripcion like '%{$buscar}%' or fecha like '%{$buscar}%' order by instalacion");
                        while ($evento = $eventos->fetch_assoc()) {
                            $img = $mysqli->query("SELECT id FROM fotos WHERE evento = {$evento['id']} limit 1");
                            $imagen = "../imagenes/nofoto.avif";
                            if ($img->num_rows == 1) {
                                $img = $img->fetch_assoc();
                                $imagen = "../imagenes/eventos/{$img['id']}.jpeg";
                            }
                            echo "<li><a href='evento.php?id={$evento['id']}'>
                                    <div><img src='{$imagen}'></div>
                                    <div>
                                        {$evento['evento']}
                                        <small class='peque'><br><i class='fa-solid fa-calendar-day'></i> {$evento['fecha']} <i class='fa-solid fa-clock'></i> {$evento['duracion']}m</small>
                                    </div>
                                    <div><i class='fa-solid fa-caret-right'></i></div>
                                  </a></li>";
                        }
                        ?>
                    </ul>
                </div>
                <?php
            } else {
                $instalaciones = $mysqli->query("SELECT distinct(instalaciones.id), instalaciones.instalacion FROM instalaciones,  eventos where instalaciones.id = eventos.instalacion order by instalaciones.instalacion");
                while ($instalacion = $instalaciones->fetch_assoc()) {
                    if (isset($_GET['idinstalacion']) && is_numeric($_GET['idinstalacion']) && $_GET['idinstalacion'] == $instalacion['id']) {
                        $idinstalacion = $contador;
                    }
                    $contador++;
                    echo "<h3>{$instalacion['instalacion']}</h3>";
                ?>
                    <div>
                        <ul class="list">
                            <?php
                            $eventos = $mysqli->query("SELECT id, evento, fecha, duracion FROM eventos where instalacion = {$instalacion['id']} order by instalacion");
                            while ($evento = $eventos->fetch_assoc()) {
                                $img = $mysqli->query("SELECT id FROM fotos WHERE evento = {$evento['id']} limit 1");
                                $imagen = "../imagenes/nofoto.avif";
                                if ($img->num_rows == 1) {
                                    $img = $img->fetch_assoc();
                                    $imagen = "../imagenes/eventos/{$img['id']}.jpeg";
                                }
                                echo "<li><a href='evento.php?id={$evento['id']}'>
                                    <div><img src='{$imagen}'></div>
                                    <div>
                                        {$evento['evento']}
                                        <small class='peque'><br><i class='fa-solid fa-calendar-day'></i> {$evento['fecha']} <i class='fa-solid fa-clock'></i> {$evento['duracion']}m</small>
                                    </div>
                                    <div><i class='fa-solid fa-caret-right'></i></div>
                                  </a></li>";
                            }
                            ?>
                        </ul>
                    </div>
            <?php }
            } ?>
        </div>


        <button class="fav" onclick="abrirFormulario();"><i class="fa-solid fa-plus"></i></button>
    </main>
    <footer>
        Eventos V0.1
    </footer>

    <script>
        function abrirFormulario() {
            window.scrollTo(0, 0);
            $("#formulario_nuevo_evento").show("slow");
        }

        function cerrarFormulario() {
            $("#formulario_nuevo_evento").hide();
        }

        $(function() {
            tinymce.init({
                selector: '#descripcionevento',
                plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount code',
                toolbar: 'undo redo | blocks fontfamily fontsize | code | bold italic underline strikethrough forecolor| link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
                language: 'es'
            });
        })



        $(function() {
            $("#listaEventos").accordion({
                heightStyle: "content",
                active: <?php echo $idinstalacion; ?>
            });
        });
    </script>
</body>

</html>