<?php include_once("includes/datos.php") ?>
<?php include_once("includes/clases/select.php") ?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zona Privada</title>

    <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.0/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="asset/style.css">

    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/ui/1.14.0/jquery-ui.js"></script>

    <!-- Place the first <script> tag in your HTML's <head> -->
    <script src="https://cdn.tiny.cloud/1/cqd5we7v96awl0waoo8iqiw30wrntutc7dvo2lhzh0zcmqfy/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>

    <script src="asset/js.js"></script>

    <script>
        $(function() {
            $("#listaInstalaciones").accordion({
                heightStyle: "content"
            });
        });
    </script>


</head>

<body>

    <header>
        <div><i onclick="menu();" class="fa-solid fa-bars"></i></div>
        <div class="centrar">
            <h1>Instalaciones</h1>
        </div>
        <div>
            
        </div>
    </header>
    <menu>
        <nav>
            <ul>
                <li><i onclick="menu();" class="fa-solid fa-xmark"></i></li>
                <li><a href="index.php"><i class="fa-solid fa-building-flag"></i> Instalaciones</a></li>
                <li><a href="eventos.php"><i class="fa-solid fa-masks-theater"></i> Eventos</a></li>
            </ul>
        </nav>
    </menu>
    <main>

        <?php
        if (isset($_GET['error'])) {
            $clase = "class='ok'";
            $texto = '<i class="fa-solid fa-circle-check"></i> Se ha creado correctamente';
            $error = base64_decode($_GET['error']);
            if ($error != "false") {
                $clase = "class='error'";
                $texto = '<i class="fa-solid fa-bug"></i> ' . $error;
            }
            echo "<div {$clase}>{$texto}</div>";
        }
        ?>

        <div id="formulario_nueva_instalacion">
            <form class="formularios" action="includes/nueva_instalacion.php" method="post" enctype="multipart/form-data">
                <div class="derecha m_arriba">
                    <i onclick="cerrarFormulario();" class="fa-solid fa-square-xmark"></i>
                </div>
                <input type="text" name="instalacion" require placeholder="Instalación" maxlength="250">
                <textarea name="descripcion" id="descripcion" placeholder=" Descripcion" maxlength="25000"></textarea>
                <input type="text" name="direccion" require placeholder="Dirección" maxlength="500">
                <input type="number" name="lon" require placeholder="Longitud">
                <input type="number" name="lat" require placeholder="Latitud">
                <?php
                $tipos = $mysqli->query("SELECT * from tipos");
                $tipos = $tipos->fetch_all(MYSQLI_NUM);
                $tipos = new select($tipos, "tipo", "tipo", "Categorías");
                ?>
                <input type="file" name="fotos[]" multiple accept=".jpeg, .jpg">
                <div class="derecha m_arriba">
                    <button class="botones" type="submit"><i class="fa-solid fa-floppy-disk"></i> Guardar</button>
                </div>
            </form>
        </div>


        <div id="listaInstalaciones" class="lista">
            <?php
            $tipos = $mysqli->query("SELECT * FROM tipos order by tipo");
            while ($tipo = $tipos->fetch_assoc()) {
                echo "<h3>{$tipo['tipo']}</h3>";
            ?>
                <div>
                    <ul class="list">
                        <?php
                        $instalaciones = $mysqli->query("SELECT id, instalacion, direccion FROM instalaciones where tipo = {$tipo['id']} order by instalacion");
                        while ($instalacion = $instalaciones->fetch_assoc()) {
                            $img = $mysqli->query("SELECT id FROM fotosinstalaciones WHERE instalacion = {$instalacion['id']} limit 1");
                            $imagen = "../imagenes/nofoto.avif";
                            if ($img->num_rows == 1) {
                                $img = $img->fetch_assoc();
                                $imagen = "../imagenes/instalaciones/{$img['id']}.jpeg";
                            }
                            echo "<li><a href='instalacion.php?id={$instalacion['id']}'>
                                    <div><img src='{$imagen}'></div>
                                    <div>
                                        {$instalacion['instalacion']}
                                        <small class='peque'><br>{$instalacion['direccion']}</small>
                                    </div>
                                    <div><i class='fa-solid fa-caret-right'></i></div>
                                  </a></li>";
                        }
                        ?>
                    </ul>
                </div>
            <?php } ?>
        </div>


        <button class="fav" onclick="abrirFormulario();"><i class="fa-solid fa-plus"></i></button>
    </main>
    <footer>
        Eventos V0.1
    </footer>

    <script>
        function abrirFormulario() {
            $("#formulario_nueva_instalacion").show("slow");
        }

        function cerrarFormulario() {
            $("#formulario_nueva_instalacion").hide();
        }

        $(function() {
            tinymce.init({
                selector: '#descripcion',
                plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount code',
                toolbar: 'undo redo | blocks fontfamily fontsize | code | bold italic underline strikethrough forecolor| link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
                language: 'es'
            });
        })
    </script>
</body>

</html>