<?php include_once("includes/datos.php"); ?>
<?php include_once("includes/clases/select.php"); ?>
<?php
$instalacion;
$id = 0;
if (isset($_GET['id']) && is_numeric($_GET['id']) && $_GET['id'] > 0) {
    $id = $_GET['id'];
    $instalacion = $mysqli->query("SELECT * FROM instalaciones WHERE id = {$id}");
    if ($instalacion->num_rows != 1) {
        header("Location: index.php");
        exit();
    } else {
        $instalacion = $instalacion->fetch_assoc();
    }
} else {
    header("Location: index.php");
    exit();
}

?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zona Privada</title>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.0/themes/base/jquery-ui.css">

    <link rel="stylesheet" href="asset/style.css">




    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/ui/1.14.0/jquery-ui.js"></script>
    <!-- Place the first <script> tag in your HTML's <head> -->
    <script src="https://cdn.tiny.cloud/1/cqd5we7v96awl0waoo8iqiw30wrntutc7dvo2lhzh0zcmqfy/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>
    <script src="asset/js.js"></script>

</head>

<body>

    <header>
        <div><i onclick="menu();" class="fa-solid fa-bars"></i></div>
        <div class="centrar">
            <h1><?php echo $instalacion['instalacion']; ?></h1>
        </div>
        <div>
            <i onclick="history.back()" class="fa-solid fa-arrow-left"></i>
        </div>
    </header>
    <menu>
        <nav>
            <ul>
                <li><i onclick="menu();" class="fa-solid fa-xmark"></i></li>
                <li><a href="index.php"><i class="fa-solid fa-building-flag"></i> Instalaciones</a></li>
                <li><a href="eventos.php"><i class="fa-solid fa-masks-theater"></i> Eventos</a></li>
            </ul>
        </nav>
    </menu>
    <main>

        <?php
        if (isset($_GET['error'])) {
            $clase = "class='ok'";
            $texto = '<i class="fa-solid fa-circle-check"></i> Operación Correcta';
            $error = base64_decode($_GET['error']);
            if ($error != "false") {
                $clase = "class='error'";
                $texto = '<i class="fa-solid fa-bug"></i> ' . $error;
            }
            echo "<div {$clase}>{$texto}</div>";
        }
        ?>

<?php
    $fotos = $mysqli->query("SELECT * FROM fotosinstalaciones WHERE instalacion = {$id} order by id");
    $eventos = $mysqli->query("SELECT id, evento, fecha, duracion FROM eventos where instalacion = {$instalacion['id']} order by fecha");
?>

        <div id="tabs">
            <ul>
                <li><a href="#tabs-1"><i class="fa-solid fa-pencil"></i><span class='nomovil'> Editar</span></a></li>
                <li><a href="#tabs-2"><i class="fa-solid fa-image"></i><span class='nomovil'> Fotos</span> (<?php echo $fotos->num_rows; ?>)</a></li>
                <li><a href="#tabs-3"><i class="fa-solid fa-masks-theater"></i><span class='nomovil'> Eventos</span> (<?php echo $eventos->num_rows; ?>)</a></li>
            </ul>
            <div id="tabs-1">
                <form class="formularios" action="includes/editar_instalacion.php" method="post">
                    <input type="hidden" name="id" value="<?php echo $instalacion['id'] ?>">
                    <input type="text" value="<?php echo $instalacion['instalacion'] ?>" name="instalacion" require placeholder="Instalación" maxlength="250">
                    <textarea name="descripcion" id="descripcion" placeholder=" Descripcion" maxlength="25000"><?php echo $instalacion['descripcion'] ?></textarea>
                    <input type="text" value="<?php echo $instalacion['direccion'] ?>" name="direccion" require placeholder="Dirección" maxlength="500">
                    <input type="number" value="<?php echo $instalacion['lon'] ?>" name="lon" require placeholder="Longitud">
                    <input type="number" value="<?php echo $instalacion['lat'] ?>" name="lat" require placeholder="Latitud">
                    <?php
                    $tipos = $mysqli->query("SELECT * from tipos");
                    $tipos = $tipos->fetch_all(MYSQLI_NUM);

                    foreach ($tipos as $key => $value) {
                        if ($value[0] == $instalacion['tipo']) {
                            $tipos[$key][2] = 1;
                        }
                    }
                    $tipos = new select($tipos, "tipo", "tipo", "Categorías");
                    ?>
                    <!-- <input type="file" name="fotos[]" multiple accept=".jpeg, .jpg"> -->
                    <div class="derecha m_arriba">
                        <button class="botones" type="submit"><i class="fa-solid fa-floppy-disk"></i> Guardar</button>
                    </div>
                </form>
            </div>
            <div id="tabs-2">
                <form class="formularios" action="includes/nuevas_fotos_instalacion.php" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="id" value="<?php echo $instalacion['id'] ?>">
                    <input type="file" name="fotos[]" multiple accept=".jpeg, .jpg">
                    <div class="derecha m_arriba">
                        <button class="botones" type="submit"><i class="fa-solid fa-floppy-disk"></i> Subir Fotos</button>
                    </div>
                </form>

                <hr>

                <ul class="listGrilla">
                    <?php
                    while ($foto = $fotos->fetch_assoc()) {
                        $imagen = "../imagenes/instalaciones/{$foto['id']}.jpeg";
                        echo "<li>
                                <div><img src='{$imagen}'></div>
                                <div><i onclick='confirmarBorrar({$foto['id']}, \"\", 0);' class='fa-solid fa-trash'></i></div>
                              </li>";
                    }
                    ?>
                </ul>
            </div>
            <div id="tabs-3">

                <div id="formulario_nuevo_evento">
                    <form class="formularios" action="includes/nuevo_evento.php" method="post" enctype="multipart/form-data">
                        <div class="derecha m_arriba">
                            <i onclick="cerrarFormulario();" class="fa-solid fa-square-xmark"></i>
                        </div>
                        <input type="hidden" name="instalacion" value="<?php echo $instalacion['id']; ?>">
                        <input type="text" name="evento" required placeholder="Evento" maxlength="500">
                        <textarea name="descripcion" id="descripcionevento" placeholder="Descripcion" maxlength="25000"></textarea>
                        <input type="datetime-local" required name="fecha" placeholder="Fecha y Hora">
                        <input type="number" name="duracion" placeholder="Duración en Minutos" required>
                        <input type="file" name="fotos[]" accept=".jpeg, .jpg" multiple>
                        <div class="derecha m_arriba">
                            <button type="submit" class="botones"><i class="fa-solid fa-floppy-disk"></i> Guardar</button>
                        </div>
                        <br><br><br><br><br><br><br><br>
                    </form>
                </div>

                <div id="listaEventos" class="lista">
                    <ul class="list">
                        <?php
                        
                        while ($evento = $eventos->fetch_assoc()) {
                            $img = $mysqli->query("SELECT id FROM fotos WHERE evento = {$evento['id']} limit 1");
                            $imagen = "../imagenes/nofoto.avif";
                            if ($img->num_rows == 1) {
                                $img = $img->fetch_assoc();
                                $imagen = "../imagenes/eventos/{$img['id']}.jpeg";
                            }
                            echo "<li><a href='evento.php?id={$evento['id']}'>
                                    <div><img src='{$imagen}'></div>
                                    <div>
                                        {$evento['evento']}
                                        <small class='peque'><br>{$evento['fecha']} - {$evento['duracion']}</small>
                                    </div>
                                    <div><i class='fa-solid fa-caret-right'></i></div>
                                  </a></li>";
                        }
                        ?>
                    </ul>
                </div>

                <button class="fav" onclick="abrirFormulario();"><i class="fa-solid fa-plus"></i></button>
            </div>
        </div>
    </main>
    <footer onclick="confirmarBorrar(<?php echo $instalacion['id']; ?>, '', 2);">
       <i class="fa-solid fa-trash"></i> Borrar
    </footer>


    <script>
        $(function() {
            tinymce.init({
                selector: '#descripcion',
                plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount code',
                toolbar: 'undo redo | blocks fontfamily fontsize | code | bold italic underline strikethrough forecolor| link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
                language: 'es'
            });


            tinymce.init({
                selector: '#descripcionevento',
                plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount code',
                toolbar: 'undo redo | blocks fontfamily fontsize | code | bold italic underline strikethrough forecolor| link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
                language: 'es'
            });

            <?php
            $tab = 0;
            if (isset($_GET['tab']) && is_numeric($_GET['tab'])) {
                $tab = $_GET['tab'];
            }
            ?>
            $("#tabs").tabs({
                active: <?php echo $tab; ?>
            });
        })

        function abrirFormulario() {
            window.scrollTo(0, 0);
            $("#formulario_nuevo_evento").show("slow");
        }

        function cerrarFormulario() {
            $("#formulario_nuevo_evento").hide();
        }
    </script>
</body>

</html>