
let abecedario = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'ñ', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'];
let mp3fondo = document.getElementById("mp3fondo");
let mp3fallo = document.getElementById("mp3fallo");
let mp3acierto = document.getElementById("mp3acierto");
let mp3ganar = document.getElementById("mp3ganar");
let mp3muerte = document.getElementById("mp3muerte");
let palabra = "";
let palabras = ["abrupto", "acervo", "acuñar", "adverso", "afable", "agazapar", "albedrio", "algarabia", "alucinante", "amalgama", "anacronico", "anatema", "añejo", "apologia", "apoplejia", "aquiescencia", "arcano", "ardid", "artificio", "ascetismo", "avieso", "baladi", "baldio", "bizarro", "blasfemia", "boato", "cabala", "caduco", "caliginoso", "candido", "canoro", "caprichoso", "casuistica", "catartico", "centelleante", "cercenar", "chasco", "chusma", "cicatero", "cimaron", "circunspecto", "coadyuvar", "coartada", "cohibido", "colerico", "comulgar", "compungido", "conciso", "conjeturar", "conspicuo", "contumaz", "corolario", "cotilleo", "cumulo", "deletereo", "demacrado", "denostar", "desazon", "desden", "desidia", "desmañado", "desmedido", "desolacion", "desvencijado", "diatriba", "difamar", "dilema", "discordia", "disentir", "disfrazar", "dislate", "disoluto", "disonancia", "divagar", "dogmatico", "elucubrar", "embrollo", "empirico", "enajenado", "enardecido", "engorro", "enigma", "envanecido", "epitome", "equivoco", "erudito", "escarnio", "esceptico", "esoterico", "espurio", "estridente", "evanescente", "exabrupto", "exceder", "exhortacion", "eximio", "exotico", "expiar", "expurgar", "extemporaneo", "fabula", "faceta", "falaz", "fatuo", "fehaciente", "fervor", "flemmatico", "fortuito", "fraguar", "furtivo", "galimatias", "garrulo", "gesticular", "gnosis", "gozoso", "gracil", "gregario", "grosero", "guadaña", "guarida", "harto", "hedonista", "hegemonico", "heterodoxo", "hilacha", "himnico", "holocausto", "hostil", "idiosincrasia", "idoneo", "ignominia", "ileso", "impasible", "impoluto", "impudico", "inane", "inasible", "incauto", "incredulo", "indeleble", "indigente", "indolente", "indomito", "indoneo", "infausto", "infame", "infructuoso", "ingenioso", "ingrato", "inhospito", "innato", "innovar", "inopinado", "insondable", "insospechado", "insustancial", "intangible", "intelecto", "intrigante", "intruso", "iracundo", "ironico", "irrefutable", "irrisorio", "lacerar", "laconico", "laico", "lastimoso", "latente", "laudatorio", "laxitud", "leguleyo", "letargo", "leviatan", "lisonja", "litigio", "loable", "locuaz", "lozano", "lugubre", "macabro", "magnanimo", "malicioso", "marasmo", "marfil", "melifluo", "mendaz", "menesteroso", "meticuloso", "misantropo", "misogino", "modesto", "mohino", "monotono", "moroso", "mutismo", "narcisista", "nebuloso", "nefando", "neofito", "nostalgia", "novelesco", "obsoleto", "obolo", "odioso", "ojeriza", "ominoso", "oprobio", "orate", "osado", "ostensible", "ostracismo", "paradigmático", "palurdo", "panegirico", "parangonar", "paroxismo", "pasivo", "patraña", "pauperrimo", "pedante", "peyorativo", "perentorio", "periplo", "perplejo", "pertinaz", "perverso", "petulante", "pirrico", "plausible", "plebeyo", "pletorico", "ponderar", "porfiado", "posponer", "pragmatico", "precario", "precepto", "predilecto", "preeminente", "prefacio", "premisa", "presuntuoso", "preterito", "prolijo", "proscrito", "prosaico", "prodigo", "protervo", "pudor", "quimera", "quimico", "quimerista", "quiosco", "quixotico", "raudo", "raudo", "recalcitrante", "recondito", "refutar", "refutar", "refulgente", "remiso", "renacer", "renuente", "reprensible", "reproche", "repudiar", "resabio", "resentimiento", "resiliente", "reverente", "rijoso", "risible", "rocambolesco", "rudo", "sagaz", "salaz", "salubre", "sandez", "sardonico", "satirico", "saudade", "secular", "sedicioso", "seductor", "señorial", "sentencioso", "sereno", "severo", "sibilino", "sinuoso", "soez", "solapado", "solipsismo", "somero", "soporifero", "sozarron", "sozobra", "subrepticio", "sutil", "taciturno", "taimado", "tardo", "tedioso", "temerario"];
let fallos = 0;
let aciertos = 0;


function pintarAbecedario() {
    let texto = "";
    for (let index = 0; index < abecedario.length; index++) {
        texto += "<div onclick='letra(" + index + ")' id='l_" + index + "'>" + abecedario[index] + "</div>";
    }
    $("#abecedario").html(texto);
}



function jugar() {
    pintarAbecedario();
    mp3ganar.pause();
    mp3muerte.pause();
    fallos = 0;
    aciertos = 0;
    palabra = palabras[getRandomInt(palabras.length)];
    console.log(palabra);
    mp3fondo.play();
    $("#botonnuevapartida").hide();
    $("#dibujo").html("<img src='imagenes/0.png'>");
    $("#dibujo").show();
    let dives = "";
    for (let index = 0; index < palabra.length; index++) {
        dives += "<div id='letra_" + index + "'></div>";
    }
    $("#letras").html(dives);
    $("#letras").css("grid-template-columns", "repeat(" + palabra.length + ", 1fr)");
}


function letra(k) {
    $("#l_" + k).css("color", "rgba(71, 71, 71, 0.719)");
    let contadordeletras = 0;
    for (let index = 0; index < palabra.length; index++) {
        if (abecedario[k] == palabra[index]) {
            $("#letra_" + index).html(abecedario[k]);
            contadordeletras++;
            aciertos++;
        }
    }

    if(aciertos == palabra.length){
        mp3fondo.pause();
        mp3ganar.play();
        $("#botonnuevapartida").show();
        $("#dibujo").html("<p>Te has librado, te reto de nuevo</p>")
        return;   
    }


    if (contadordeletras == 0) {
        fallos++;
        $("#dibujo").html("<img src='imagenes/" + fallos + ".png'>")
        mp3fallo.play();
        if(fallos == 6){
            mp3fondo.pause();
            mp3muerte.play();
            $("#botonnuevapartida").show();
            $("#dibujo").html("<p>HAS MUERTO!!<br>COMIDA PARA LOS CUERVOS</p>")
            return
        }
    } else {
        mp3acierto.play();
    }
}


function getRandomInt(max) {
    return Math.floor(Math.random() * max);
}