<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Intro BBDD</title>

    <script
        src="https://code.jquery.com/jquery-3.7.1.js"
        integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4="
        crossorigin="anonymous"></script>
</head>

<body>

    <?php

    function pintarArbol($arbol, $padre = 0)
    {
        echo "<ul>";
        foreach ($arbol as $key => $value) {
            if ($value[0] == $padre && $value[2] != 0) {
                echo "<li><input type='radio' name='padre' value='{$value[2]}'> <input id='cat_{$value[2]}' onchange='hacambiado({$value[2]});' type='text' value='{$value[1]}'> <a href='borrar.php?id=$value[2]'>[X]</a> <a href='editar.php?id=$value[2]'>[Edit]</a>";
                pintarArbol($arbol, $value[2]);
                echo "</li>";
            }
        }
        echo "</ul>";
    }

    include_once("datos.php");


    if ($arbol->errno == 0) {
        try {
            $categorias = $arbol->query("SELECT * from categorias");
        } catch (mysqli_sql_exception $e) {
            error_log($e->getMessage()); // Log the error manually
            die("Error de SQL: " . $e->getMessage());
        }

        if ($categorias != false) {
            if ($categorias->num_rows > 0) {
                $arbolCategorias = [];
                $contador = 1;
                while ($categoria = $categorias->fetch_assoc()) {
                    $arbolCategorias[$contador++] = [$categoria['padre'], $categoria['categoria'], $categoria['id']];
                }
    ?>
                <form action="guardar.php" method="post">
                    <?php
                    if (isset($_GET['error'])) {
                        echo "<p class='error'>Se ha producido un error: {$_GET['error']} </p>";
                    }
                    ?>
                    <fieldset>
                        <legend>Categorías</legend>
                        <ul>
                            <li><input type='radio' name='padre' value='0'> DIOS</li>
                            <?php pintarArbol($arbolCategorias, 0); ?>
                        </ul>
                        <input type="text" name="nuevacategoria" required placeholder="Nueva Categoría">
                        <input type="submit" value="Guardar">
                    </fieldset>
                </form>
    <?php



            } else {
                echo "Sin Registros";
            }
        } else {
            echo "NO funciona";
        }
    }

    ?>

    <script>
        function hacambiado(id) {
            $.ajax({
                    method: "POST",
                    url: "editarguardarajax.php",
                    data: {
                        id: id,
                        categoria: $("#cat_" + id).val()
                    }
                })
                .done(function(msg) {
                    alert("Categoría Actualizada " + msg);
                });
        }
    </script>

</body>

</html>