<?php
class tabla
{
    private $conexion = "";
    private $sql = "";
    private $result;


    public function __construct($conexion)
    {
        $this->conexion = $conexion;
    }


    public function enviarSql($query)
    {
        $this->sql = $query;
        try {
            $this->result = $this->conexion->query($this->sql);
        } catch (mysqli_sql_exception $e) {
            echo "ERROR SQL";
        }
    }


    public function pintar($id, $caption = "")
    {
        if ($this->result->num_rows > 0) {
            $cantidadCampos = $this->result->field_count;
            echo "<table class='display' id='{$id}'><caption>{$caption}</caption><thead><tr>";
            while ($columna = $this->result->fetch_field()) {
                echo "<th>";
                echo $columna->name;
                echo "</th>";
            }
            echo "</tr></thead>";
            echo "<tbody>";
            while ($row = $this->result->fetch_row()) {
                echo "<tr>";
                for ($p = 0; $p < $cantidadCampos; $p++) {
                    echo "<td>{$row[$p]}</td>";
                }
                echo "</tr>";
            }
            echo "</tbody>";
            echo "</table>";

            echo "<script>
                table2 = new DataTable('#{$id}', {
                    language: {
                    url: 'includes/idioma.json',
                    },
                });            
            </script>";
        } else {
            echo "<p class='alerta'> <i class='fa-solid fa-circle-exclamation'></i> No hay registro en estos momentos </p>";
        }
    }
}
