<?php


function esbisiesto($year)
{
    if ($year % 4 == 0 && ($year % 100 != 0 || $year % 400 == 0)) {
        return 1;
    } else {
        return 0;
    }
}

function esfechavalida($dia, $mes, $year)
{
    $diaspormes = [31, 28 + esbisiesto($year), 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    if (
        ($year >= 1) &&
        ($mes >= 1 && $mes <= 12) &&
        ($dia >= 1) &&
        ($dia <= $diaspormes[$mes - 1])
    ) {
        return 1;
    } else {
        return 0;
    }
}


function cantidaddias($dia, $mes, $year)
{
    $diaspormes = [31, 28 + esbisiesto($year), 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    $total = $dia;
    $year--;
    $total += $year * 365;
    $total += ($year - ($year % 4)) / 4;
    $total -= ($year - ($year % 100)) / 100;
    $total += ($year - ($year % 400)) / 400;
    for ($mesecito = 0; $mesecito < $mes - 1; $mesecito++) {
        $total += $diaspormes[$mesecito];
    }
    return $total;
}


function pintarMes($mes, $year)
{
    $dia1 = cantidaddias(1, $mes, $year);
    $dia1 = $dia1 % 7;
    if ($dia1 == 0) {
        $dia1 = 7;
    }
    $dia = 1;
    $contador = 1;
    $diaspormes = [31, 28 + esbisiesto($year), 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    $meses = ["Enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
    $dias = $diaspormes[$mes - 1];

    echo "<table class='cinereousTable'><caption>" . $meses[$mes - 1] . " de " . $year . "</caption><thead><tr>";
    echo "<th>L</th><th>M</th><th>X</th><th>J</th><th>V</th><th>S</th><th>D</th></tr></thead><tbody>";
    while ($dia < $dias) {
        echo "<tr>";
        for ($d = 1; $d <= 7; $d++) {
            echo "<td>";
            if ($contador >= $dia1 && $dia <= $dias) {
                echo $dia++;
            }
            echo "</td>";
            $contador++;
        }
        echo "</tr>";
    }
    echo "</tbody></table>";
}
