<?php
/**
 * Validad si un año es bisiesto
 * @param int $year año a validar
 * @return int 1 bisiesto, 0 no bisiesto
 */
function bisiesto($year)
{
    if ($year % 4 == 0 && ($year % 100 != 0 || $year % 400 == 0)) {
        return 1;
    } else {
        return 0;
    }
}


/**
 * Permite validar una fecha
 * @param int $dia dia de la fecha a validar
 * @param int $mes mes de la fecha a validar
 * @param int $year año de la fecha a validar
 * @return int 0 si la fecha no es válida, 1 la fecha es válida
 */
function validarFecha($dia, $mes, $year){
    $esvalida = 0;
    $esbisiesto = bisiesto($year);
    $dias_por_mes = [31, 28 + $esbisiesto, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    if((is_integer($dia) && is_integer($year) && is_integer($mes)) && ($mes >= 1 && $mes <= 12) && ($dia >= 1 && $dia <= $dias_por_mes[$mes - 1])){
        $esvalida = 1;
    }
    return $esvalida;
}


/**
 * Nos da la cantiad de días que han pasado desde el 1/1/1
 * @param int $dia dia de la fecha 
 * @param int $mes mes de la fecha 
 * @param int $year año de la fecha
 * @return int la cantidad de días que han pasado. -1 si la fecha no es válida
 */
function contarDias($dia, $mes, $year){
    $totalDias = 0;
    if(validarFecha($dia, $mes, $year) == 1 ){
        $esbisiesto = bisiesto($year);
        $dias_por_mes = [31, 28 + $esbisiesto, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        $year--;
        $totalDias += $year * 365;
        $totalDias += ($year - ($year % 4)) / 4;
        $totalDias -= ($year - ($year % 100)) / 100;
        $totalDias += ($year - ($year % 400)) / 400;
        for ($m=0; $m <= $mes - 2; $m++) { 
            $totalDias += $dias_por_mes[$m];
        }
        $totalDias += $dia;
        return $totalDias;
    } else {
        return -1;
    }
}


/**
 * Permite encontrar el día de la semana de una fecha
 * @param int $dia dia de la fecha 
 * @param int $mes mes de la fecha 
 * @param int $year año de la fecha 
 * @return int 0 domingo, 1 lunes, 2 martes ... 6 sábado
 */
function diaSemana($dia, $mes, $year){
    return contarDias($dia, $mes, $year) % 7;
}
