<?php
include_once("prohibir.php");
include_once("includes/categorias.php");
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>La Lista de la Comprar</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="js.js"></script>
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.0/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/jquery-3.7.1.js"></script>
    <script src="https://code.jquery.com/ui/1.14.0/jquery-ui.js"></script>
    <script>
        $(function() {
            $("#fuelle").accordion({
                collapsible: true,
                active: 1000
            });
        });
    </script>
    <style>
        .ui-accordion .ui-accordion-content {
            padding: 0px;
        }
    </style>
</head>

<body>

    <header>
        <form action="guardar.php" method="post">
            <a href="salir.php"><i class="fa-solid fa-arrow-right-from-bracket"></i></a>
            <input type="text" id="producto" name="producto" placeholder="Producto" required>
            <button type="button" onclick="recognition.start();"><i class="fa-solid fa-microphone"></i></button>
            <select name="categoria" required>
                <option value="">- Categorías -</option>
                <?php
                foreach ($categorias as $key => $value) {
                    echo "<option value='{$key}'>{$value}</option>";
                }
                ?>

            </select>
            <button type="submit"><i class="fa-solid fa-plus"></i></button>
        </form>
    </header>

    <main>
        <div id="fuelle">
            <?php
            $productos = [];
            $fichero = "";
            if(file_exists("productos/{$keyusuario}.txt")){
                $fichero = file_get_contents("productos/{$keyusuario}.txt");
            }
            if (strlen($fichero) > 0) {
                $productos = unserialize($fichero);
            }

            if (count($productos) > 0) {
                foreach ($productos as $keycategoria => $arrayproductos) {
                    echo "<h3>{$categorias[$keycategoria]}</h3>";
                    echo "<div>";
                    echo "<ul>";
                    foreach ($arrayproductos as $key => $value) {
                        echo "<li>
                            <div>{$value}</div>
                            <div><a href='borrar.php?c={$keycategoria}&p={$key}'><i class='fa-solid fa-cart-plus'></i></a></div>
                        </li>";
                    }
                    echo "</ul>";
                    echo "</div>";
                }
            } else {
                echo "<p class='error'><i class='fa-solid fa-bell'></i> De momento no tiene nada en su lista de la compra</p>";
            }
            ?>
        </div>
    </main>

</body>

</html>