<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>La Lista de la Comprar</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="js.js"></script>
</head>

<body>

    <header>
        <form action="guardar.php" method="post">
            <input type="text" id="producto" name="producto" placeholder="Producto" required>
            <button type="button" onclick="recognition.start();"><i class="fa-solid fa-microphone"></i></button>
            <button type="submit"><i class="fa-solid fa-list"></i></button>
        </form>
    </header>

    <main>
        <?php
        $productos = [];
        $fichero = file_get_contents("productos.txt");
        if (strlen($fichero) > 0) {
            $productos = unserialize($fichero);
        }

        if (count($productos) > 0) {
            echo "<ul>";
            foreach ($productos as $key => $value) {
                echo "<li>
                    <div>{$value}</div>
                    <div><a href='borrar.php?k={$key}'><i class='fa-solid fa-cart-plus'></i></a></div>
                </li>";
            }
            echo "</ul>";
        } else {
            echo "<p class='error'><i class='fa-solid fa-bell'></i> De momento no tiene nada en su lista de la compra</p>";
        }
        ?>
    </main>

</body>

</html>